ORCA/M Asm65816 2.1.0

0001 796B                       title 'Desk Mgr Patch        GS ROM 3 Patch' 
0002 796B              ******************************************************************
0003 796B              *
0004 796B              *                   Desk manager patches for ROM 3
0005 796B              *
0006 796B              * System Disk 5.0
0007 796B              *
0008 796B              *
0009 796B              * 01 Jun 89         Steven Glass
0010 796B              *
0011 796B              * We just discovered that the NDA calls are re-entrant and when
0012 796B              * this occurs the nda handle list is unlocked by the second call
0013 796B              * but the first call doesn't know it.
0014 796B              *
0015 796B              * This leads us to use dangling handles.  To fix this we
0016 796B              * save the state of the handle before each call and restore
0017 796B              * it at the end.
0018 796B              *
0019 796B              * 28 Aug 89         Harry Yee
0020 796B              *
0021 796B              * Patch calls AddToRunQ and RemoveFromRunQ. These calls were
0022 796B              * calling DerefNDAList but never UnlockNDAList. This caused
0023 796B              * the NDAList handle to stay locked. BRC #52333.
0024 796B              *
0025 796B              * 17-Sep-90         Dave Lyons
0026 796B              *
0027 796B              * Removed dependency on all.macros.
0028 796B              *
0029 796B              * 19-Sep-90         Dave Lyons
0030 796B              *
0031 796B              * Added GetIndDAInfo and CallDeskAcc skeletons.
0032 796B              * Version number is $8304.
0033 796B              *
0034 796B              * 25-Nov-90         Dave Lyons
0035 796B              *
0036 796B              * Changed FixAppleMenu patch to call FixAppleMenu2 in Desk:NDACalls
0037 796B              * (this version conditionally sorts the names).
0038 796B              *
0039 796B              * 27-Nov-90         Dave Lyons
0040 796B              *
0041 796B              * Patch ChooseCDA to call SortCDAs.
0042 796B              *
0043 796B              * 3-Jan-91          Dave Lyons
0044 796B              *
0045 796B              * Changed SystemEvent so that Apple-w or Apple-W with a System
0046 796B              * window in front calls CloseNDAByWinPtr and returns TRUE, instead
0047 796B              * of letting the DA or the application handle the Apple-W.
0048 796B              *
0049 796B              * 12-Feb-91         Dave Lyons
0050 796B              *
0051 796B              * Patched ChooseCDA (into the Desk project) so it supports letter
0052 796B              * keys now (and uses a sane Event Mask on the GetNextEvent call).
0053 796B              *
0054 796B              * Made DABootInit store monkeyin in KeyInput for CDA menu.
0055 796B              *
0056 796B              * 19-Feb-91         Dave Lyons
0057 796B              *
0058 796B              * Moved GetIndDAInfo and CallDeskAcc into Desk:NDACalls.
0059 796B              * Added new call GetDeskGlobal to the call table.
0060 796B              *
0061 796B              * Killed local patches in favor of Desk:NDACalls for the
0062 796B              * following revised calls:  SystemClick, SystemEdit,
0063 796B              * SystemEvent, CloseNDAByWinPtr.
0064 796B              *
0065 796B              * Since we're calling stuff directly in NDACalls.asm now, I
0066 796B              * made DeskBootInit zero out $E01D6E, and StartUsUp and ShutUsDown
0067 796B              * increment and decrement it so that the NDACalls code doesn't
0068 796B              * unlock the NDAList handle when it shouldn't.
0069 796B              *
0070 796B              * 4-Mar-91          Dave Lyons
0071 796B              *
0072 796B              * Add SendRequest calls to DeskStartUp and DeskShutDown.
0073 796B              *
0074 796B              * 11-Mar-91         Dave Lyons
0075 796B              *
0076 796B              * Changed name of GetIndDAInfo to GetDeskAccInfo.
0077 796B              *
0078 796B              * 21-Apr-91         Dave Lyons
0079 796B              *
0080 796B              * Changed SystemTask to return with no error if GS/OS is busy.
0081 796B              *
0082 796B              * 2-May-91          Dave Lyons
0083 796B              *
0084 796B              * Patch CloseAllNDAs to close non-NDA system windows (code in
0085 796B              * Desk:NDACalls.asm).
0086 796B              *
0087 796B              * 20-May-91         Dave Lyons
0088 796B              *
0089 796B              * Changed to use SystemTask from Desk:NDACalls.asm to be just
0090 796B              * like ROM 1.
0091 796B              *
0092 796B              * 5-Aug-91          Dave Lyons
0093 796B              *
0094 796B              * Added paranoia check to DeskStartUp--checks for GS/OS and
0095 796B              * several tools; takes no action if they aren't here.
0096 796B              *
0097 796B              * 4-Sep-91          Dave Lyons
0098 796B              *
0099 796B              * Now calls the paranoid OpenNDA in NDACalls.asm (it sets the
0100 796B              * port to something safe around opening the NDA).
0101 796B              *
0102 796B              * 16-Sep-91         Dave Lyons
0103 796B              *
0104 796B              * DeskStartUp and DeskShutDown maintain RealDeskStatus, so that
0105 796B              * FixAppleMenu can use it.
0106 796B              *
0107 796B              * 17-Sep-91         Dave Lyons
0108 796B              *
0109 796B              * Moved a lot of calls to Tool.Setup.
0110 796B              *
0111 796B              * 5-Feb-92          Dave Lyons
0112 796B              *
0113 796B              * Version $0304 for 6.0 final.  DeskVersion no longer falls
0114 796B              * into DeskBootInit!
0115 796B              *
0116 796B              ******************************************************************
0117 796B              *
0118 796B              * 7-Jul-92          Dave Lyons for 6.0.1
0119 796B              *
0120 796B              * DeskShutDown zeroes $00/07FC if slot 4 is set to Mouse.
0121 796B              * This should stop the mouse from freezing on exiting the
0122 796B              * CDA menu in a desktop application, after running an app
0123 796B              * (like ProTERM 3.0) that leaves a nonzero value in $07FC.
0124 796B              *
0125 796B              ******************************************************************
0126 796B
0127 796B              ****************************************************************
0128 796B              *                                                              *
0129 796B              *              Copyright (C) 1989-1992                         *
0130 796B              *              All Rights Reserved                             *
0131 796B              *              Apple Computer, Inc.                            *
0132 796B              *                                                              *
0133 796B              ****************************************************************
0134 796B                       Blanks off 
0135 796B                       String asis 
0136 796B
0137 796B                       include 'all.macros' 
0138 796B
0139 796B                       include ':::sys.equs.asm' 
0140 796B                       include 'e16.memory' 
0141 796B                       include ':::desk:Desk.Equates.asm' 
0142 796B
0143 796B
0144 796B                       DefineStack 
0145 796B              OrigD    word 
0146 796B              TheHandle long 
0147 796B              RTL1     block 3 
0148 796B              RTL2     block 3 
0149 796B              TheInput long 
0150 796B
0151 796B
0152 796B                       import RemoveNDA 
0153 796B                       import ChooseCDA 
0154 796B
0155 796B              ****************************************************************
0156 796B              *
0157 796B              DeskCallTable PROC EXPORT 
0158 796B              *
0159 796B              * Contains pointers to all the calls we are patching.
0160 796B              *
0161 796B              *
0162 796B              * Inputs:
0163 796B              *                   none
0164 796B              *
0165 796B              * Outputs:
0166 796B              *                   none
0167 796B              *
0168 796B              * External Refs:
0169 796B              *                   none
0170 796B              *
0171 796B              * Entry Points:
0172 796B              *                   none
0173 796B              *
0174 796B                       longa on                       ; mode
0175 796B                       longi on
0176 796B              *
0177 796B              ****************************************************************
0178 796B
0179 796B              TheBeginning  
0180 796B 26 00 00 00           DC L:(TheEnd-TheBeginning)/4   ; num calls + 1
0181 796F A2 7D 02 00           DC L:DABootInit-1              ;                       0105
0182 7973 02 7D 02 00           DC L:DAStartup-1               ;                       0205 patched 4-Mar-91 DAL
0183 7977 5F 7D 02 00           DC L:DAShutdown-1              ;                       0305 patched 4-Mar-91 DAL
0184 797B 98 7D 02 00           DC L:DAVersion-1               ;                       0405
0185 797F 00 00 00 00           DC L:0                         ; DAReset-1           ; 0505
0186 7983 00 00 00 00           DC L:0                         ; DAStatus-1          ; 0605
0187 7987 00 00 00 00           DC L:0                         ; oEndCall0-1         ; 0705     reserved
0188 798B 00 00 00 00           DC L:0                         ; oEndCall0-1         ; 0805     reserved
0189 798F 00 00 00 00           DC L:0                         ; SaveScreen-1        ; 0905
0190 7993 00 00 00 00           DC L:0                         ; RestScreen-1        ; 0A05
0191 7997 00 00 00 00           DC L:0                         ; SaveAll-1           ; 0B05
0192 799B 00 00 00 00           DC L:0                         ; RestAll-1           ; 0C05
0193 799F 00 00 00 00           DC L:0                         ; oEndCall0-1         ; 0D05
0194 79A3 DE 7D 02 00           DC L:InstallNDA-1              ;                       0E05
0195 79A7 00 00 00 00           DC L:0                         ; instcda-1           ; 0F05
0196 79AB 00 00 00 00           DC L:0                         ; oEndCall0-1         ; 1005
0197 79AF 00 00 00 00           DC L:0                         ;[ts] ChooseCDA-1     ; 1105
0198 79B3 00 00 00 00           DC L:0                         ; oEndCall0-1         ; 1205
0199 79B7 00 00 00 00           DC L:0                         ; setdastrptr-1       ; 1305
0200 79BB 00 00 00 00           DC L:0                         ; getdastrptr-1       ; 1405
0201 79BF F5 7D 02 00           DC L:OpenNDAentry-1            ;                       1505
0202 79C3 0E 7E 02 00           DC L:CloseNDA-1                ;                       1605
0203 79C7 00 00 00 00           DC L:0                         ;[ts] SystemClick-1   ; 1705
0204 79CB 00 00 00 00           DC L:0                         ;[ts] SystemEdit-1    ; 1805
0205 79CF 00 00 00 00           DC L:0                         ;[ts] SystemTask-1    ; 1905
0206 79D3 00 00 00 00           DC L:0                         ;[ts] SystemEvent-1   ; 1A05
0207 79D7 23 7E 02 00           DC L:GetNumNDAs-1              ;                       1B05
0208 79DB 00 00 00 00           DC L:0                         ;[ts] CloseNDAbyWinPtr-1 1C05
0209 79DF 00 00 00 00           DC L:0                         ;[ts] CloseAllNDAs-1  ; 1D05
0210 79E3 00 00 00 00           DC L:0                         ;[ts] FixAppleMenu-1  ; 1E05
0211 79E7 3A 7E 02 00           DC L:AddToRunQ-1               ;                       1F05
0212 79EB 51 7E 02 00           DC L:RemoveFromRunQ-1          ;                       2005
0213 79EF 00 00 00 00           DC L:0                         ; RemoveCDA-1         ; 2105
0214 79F3 00 00 00 00           DC L:0                         ;[ts] RemoveNDA-1     ; 2205
0215 79F7 00 00 00 00           DC L:0                         ;[ts] GetDeskAccInfo-1  2305  19-Sep-90 DAL
0216 79FB 00 00 00 00           DC L:0                         ;[ts] CallDeskAcc-1   ; 2405  19-Sep-90 DAL
0217 79FF 00 00 00 00           DC L:0                         ;[ts] GetDeskGlobal-1 ; 2505  19-Feb-91 DAL
0218 7A03              TheEnd    
0219 7A03                       ENDP 
0220 7A03
0221 7A03
0222 7A03              ****************************************************************
0223 7A03              *
0224 7A03              * DeskStartUp patch -- 4-Mar-91 DAL
0225 7A03              *
0226 7A03              * Call the ROM and then call SendRequest($0502)
0227 7A03              *
0228 7A03              ****************************************************************
0229 7A03              DAStartUp proc 
0230 7A03
0231 7A03              *** added 5-Aug-91 DAL -- if proper environment is not set up, do nothing
0232 7A03 48                    pha   
0233 7A04 5A                    phy   
0234 7A05
0235 7A05 AF BC 00 E1           lda   >$e100bc                 ;OS_Kind
0236 7A09 29 FF 00              and   #$00ff
0237 7A0C 3A                    dec   a
0238 7A0D D0 1E                 bne   @error                   ;must be $01=GS/OS
0239 7A0F
0240 7A0F A2 05 00              ldx   #@neededToolsEnd-@neededTools
0241 7A12 CA           @checkOneTool dex   
0242 7A13 30 24                 bmi   @toolsAreHere
0243 7A15 DA                    phx   
0244 7A16 BF 34 7D 02           lda   >@neededTools,x
0245 7A1A 29 FF 00              and   #$00FF
0246 7A1D 09 00 06              ora   #$0600                   ;compute xxxStatus function code
0247 7A20 AA                    tax   
0248 7A21 F4 00 00              pea   0
0249 7A24 22 00 00 E1           jsl   $e10000                  ;make the call
0250 7A28 68                    pla   
0251 7A29 FA                    plx   
0252 7A2A A8                    tay   
0253 7A2B D0 E5                 bne   @checkOneTool            ;nonzero status --> go back for more
0254 7A2D
0255 7A2D 7A           @error   ply   
0256 7A2E 68                    pla   
0257 7A2F A9 00 00              lda   #0
0258 7A32 18                    clc   
0259 7A33 6B                    rtl   
0260 7A34
0261 7A34 0E           @neededTools DC B:$0E                   ;window
0262 7A35 0F                    DC B:$0F                       ;menu
0263 7A36 10                    DC B:$10                       ;control
0264 7A37 14                    DC B:$14                       ;line edit
0265 7A38 15                    DC B:$15                       ;dialog
0266 7A39              ;;;      DC B:$16                       ;scrap (omitted...I'm feeling generous)
0267 7A39              @neededToolsEnd  
0268 7A39
0269 7A39 7A           @toolsAreHere ply   
0270 7A3A 68                    pla   
0271 7A3B              *** end 5-Aug-91 DAL
0272 7A3B
0273 7A3B 22 0E C7 FE           jsl   $fec70e
0274 7A3F 48                    pha   
0275 7A40
0276 7A40 A9 FF FF              lda   #$ffff                   ;16-Sep-91 DAL
0277 7A43 8F BE 1D E0           sta   >RealDeskStatus          ;16-Sep-91 DAL
0278 7A47
0279 7A47 F4 02 05              pea   $0502                    ;request code
0280 7A4A A9 00 00              lda   #0
0281 7A4D 48                    pha                            ;how = everybody
0282 7A4E 48                    pha   
0283 7A4F 48                    pha                            ;target = nil
0284 7A50 48                    pha   
0285 7A51 48                    pha                            ;dataIn = nil
0286 7A52 48                    pha   
0287 7A53 48                    pha                            ;dataOut = nil
0288 7A54 A2 01 1C 22           _SendRequest 
0289 7A5B
0290 7A5B 68                    pla   
0291 7A5C C9 01 00              cmp   #1
0292 7A5F 6B                    rtl   
0293 7A60
0294 7A60                       EndP 
0295 7A60
0296 7A60              ****************************************************************
0297 7A60              *
0298 7A60              * DeskShutDown patch -- 4-Mar-91 DAL
0299 7A60              *
0300 7A60              * Call the ROM and then call SendRequest($0503)
0301 7A60              *
0302 7A60              ****************************************************************
0303 7A60              DAShutDown proc 
0304 7A60
0305 7A60              *** added 7-Jul-92 DAL
0306 7A60              *** If slot 4 is internal then zap $07FC mouse mode
0307 7A60 48                    pha   
0308 7A61 E2 20                 sep   #$20
0309 7A63                       longa off
0310 7A63 AF 2D C0 E1           lda   >$E1C02D
0311 7A67 29 10                 and   #$10
0312 7A69 D0 06                 bne   @external4
0313 7A6B A9 00                 lda   #0
0314 7A6D 8F FC 07 00           sta   >$0007FC
0315 7A71 C2 20        @external4 rep   #$20
0316 7A73                       longa on
0317 7A73 68                    pla   
0318 7A74              *** end 7-Jul-92
0319 7A74
0320 7A74 22 29 C7 FE           jsl   $fec729
0321 7A78 48                    pha   
0322 7A79
0323 7A79 A9 00 00              lda   #0                       ;16-Sep-91 DAL
0324 7A7C 8F BE 1D E0           sta   >RealDeskStatus          ;16-Sep-91 DAL
0325 7A80
0326 7A80 F4 03 05              pea   $0503                    ;request code for DeskShutDown
0327 7A83 A9 00 00              lda   #0
0328 7A86 48                    pha                            ;how = everybody
0329 7A87 48                    pha   
0330 7A88 48                    pha                            ;target = nil
0331 7A89 48                    pha   
0332 7A8A 48                    pha                            ;dataIn = nil
0333 7A8B 48                    pha   
0334 7A8C 48                    pha                            ;dataOut = nil
0335 7A8D A2 01 1C 22           _SendRequest 
0336 7A94
0337 7A94 68                    pla   
0338 7A95 C9 01 00              cmp   #1
0339 7A98 6B                    rtl   
0340 7A99
0341 7A99              ;;;	export RealDeskStatus
0342 7A99              ;;;RealDeskStatus	dc.w 0
0343 7A99
0344 7A99                       EndP 
0345 7A99
0346 7A99
0347 7A99              ****************************************************************
0348 7A99              *
0349 7A99              DAVersion PROC 
0350 7A99              *
0351 7A99              * Returns the version number of the desk manager
0352 7A99              *
0353 7A99              *
0354 7A99              * Inputs:
0355 7A99              *                   none
0356 7A99              *
0357 7A99              * Outputs:
0358 7A99              *                   work : The patched version number
0359 7A99              *
0360 7A99              * External Refs:
0361 7A99              *                   Falls into the boot init code.
0362 7A99              *
0363 7A99              * Entry Points:
0364 7A99              *                   none
0365 7A99              *
0366 7A99                       longa on                       ; mode
0367 7A99                       longi on
0368 7A99              *
0369 7A99              ****************************************************************
0370 7A99
0371 7A99 A9 04 03              lda   #$0304                   ;5-Feb-92 DAL
0372 7A9C 83 07                 sta   7,s
0373 7A9E              *** added 5-Feb-92 DAL
0374 7A9E A9 00 00              lda   #0
0375 7AA1 18                    clc   
0376 7AA2 6B                    rtl   
0377 7AA3              *** end 5-Feb-92
0378 7AA3
0379 7AA3                       ENDP 
0380 7AA3
0381 7AA3
0382 7AA3              ****************************************************************
0383 7AA3              *
0384 7AA3              DABootInit PROC 
0385 7AA3              *
0386 7AA3              * Simple routine to do nothing so when patch is installed,
0387 7AA3              * nothing bad happens.
0388 7AA3              *
0389 7AA3              *
0390 7AA3              * Inputs:
0391 7AA3              *                   none
0392 7AA3              *
0393 7AA3              * Outputs:
0394 7AA3              *                   none
0395 7AA3              *
0396 7AA3              * External Refs:
0397 7AA3              *                   none
0398 7AA3              *
0399 7AA3              * Entry Points:
0400 7AA3              *                   none
0401 7AA3              *
0402 7AA3                       longa on                       ; mode
0403 7AA3                       longi on
0404 7AA3              *
0405 7AA3              ****************************************************************
0406 7AA3
0407 7AA3              ;;; Tool.Setup now inits keyinput (17-Sep-91 DAL)
0408 7AA3              ;;;	import monkeyin
0409 7AA3              ;;;
0410 7AA3              ;;;	lda	#monkeyin
0411 7AA3              ;;;	sta	>keyinput	;added 12-Feb-91 DAL
0412 7AA3
0413 7AA3 A9 00 00              lda   #0
0414 7AA6 8F 6E 1D E0           sta   >$e01d6e                 ;counts number of re-times Desk Mgr is
0415 7AAA                                                      ;re-entrantly active (used in NDACalls)
0416 7AAA
0417 7AAA              ***	lda	#0	;already 0
0418 7AAA 18                    clc   
0419 7AAB 6B                    RTL   
0420 7AAC
0421 7AAC                       ENDP 
0422 7AAC
0423 7AAC
0424 7AAC              ****************************************************************
0425 7AAC              *
0426 7AAC              StartUsUp PROC 
0427 7AAC              *
0428 7AAC              * This routine is used by all the patched nda calls to 
0429 7AAC              * save the lock status on the stack.
0430 7AAC              *
0431 7AAC              * It preserves a and y but trashes x.
0432 7AAC              *
0433 7AAC              * It also sets the d-page to the stack
0434 7AAC              *
0435 7AAC              *
0436 7AAC              * Inputs:
0437 7AAC              *                   a & y have the handle to global data
0438 7AAC              *
0439 7AAC              * Outputs:
0440 7AAC              *                   none
0441 7AAC              *
0442 7AAC              * External Refs:
0443 7AAC              *                   none
0444 7AAC              *
0445 7AAC              * Entry Points:
0446 7AAC              *                   none
0447 7AAC              *
0448 7AAC                       longa on                       ; mode
0449 7AAC                       longi on
0450 7AAC              *
0451 7AAC              ****************************************************************
0452 7AAC
0453 7AAC
0454 7AAC FA                    plx                            ; pull off the rts addr into x
0455 7AAD 5A                    phy                            ; push y and a (the handle to the data area)
0456 7AAE 48                    pha   
0457 7AAF 0B                    phd                            ; save d-reg
0458 7AB0 3B                    tsc                            ; turn stack into direct page
0459 7AB1 5B                    tcd   
0460 7AB2
0461 7AB2 A0 04 00              ldy   #4                       ; save the lock status on the stack
0462 7AB5 B7 03                 lda   [TheHandle],y
0463 7AB7 48                    pha   
0464 7AB8
0465 7AB8 DA                    phx                            ; put back rts and 
0466 7AB9
0467 7AB9              *** added 19-Feb-91 DAL
0468 7AB9 AF 6E 1D E0           lda   >$e01d6e
0469 7ABD 1A                    inc   a
0470 7ABE 8F 6E 1D E0           sta   >$e01d6e
0471 7AC2              *** end of 19-Feb-91 DAL
0472 7AC2
0473 7AC2 A5 03                 lda   TheHandle                ; restore the incoming WAP
0474 7AC4 A4 05                 ldy   TheHandle+2
0475 7AC6
0476 7AC6 60                    rts                            ; return.
0477 7AC7
0478 7AC7                       ENDP 
0479 7AC7
0480 7AC7              ****************************************************************
0481 7AC7              *
0482 7AC7              ShutUsDown PROC 
0483 7AC7              *
0484 7AC7              * Restores the lock status from the stack.  Cleans up the stack
0485 7AC7              * and calls the strip routine.
0486 7AC7              *
0487 7AC7              *
0488 7AC7              * Inputs:
0489 7AC7              *                   on stack
0490 7AC7              *
0491 7AC7              * Outputs:
0492 7AC7              *                   none
0493 7AC7              *
0494 7AC7              * External Refs:
0495 7AC7              *                   none
0496 7AC7              *
0497 7AC7              * Entry Points:
0498 7AC7              *                   none
0499 7AC7              *
0500 7AC7                       longa on                       ; mode
0501 7AC7                       longi on
0502 7AC7              *
0503 7AC7              ****************************************************************
0504 7AC7
0505 7AC7 68                    pla                            ; restore the lock status
0506 7AC8 5A                    phy                            ; save the strip value
0507 7AC9 A0 04 00              ldy   #4                       ; store the lock status
0508 7ACC 97 03                 sta   [TheHandle],y
0509 7ACE 7A                    ply                            ; restore the strip value.
0510 7ACF
0511 7ACF              *** added 19-Feb-91 DAL
0512 7ACF AF 6E 1D E0           lda   >$e01d6e
0513 7AD3 3A                    dec   a
0514 7AD4 8F 6E 1D E0           sta   >$e01d6e
0515 7AD8              *** end of 19-Feb-91 DAL
0516 7AD8
0517 7AD8 2B                    pld                            ; restore the d-page
0518 7AD9 68                    pla                            ; clean off the handle
0519 7ADA 68                    pla   
0520 7ADB 5C 84 01 E1           jml   ToStrip                  ; use y and x to fall into stripping code
0521 7ADF
0522 7ADF                       ENDP 
0523 7ADF
0524 7ADF
0525 7ADF              ****************************************************************
0526 7ADF              *
0527 7ADF              InstallNDA PROC 
0528 7ADF              *
0529 7ADF              *
0530 7ADF                       longa on                       ; mode
0531 7ADF                       longi on
0532 7ADF              *
0533 7ADF              ****************************************************************
0534 7ADF
0535 7ADF
0536 7ADF 20 AC 7D              jsr   StartUsUp
0537 7AE2
0538 7AE2
0539 7AE2 D4 0F                 pei   TheInput+2               ; make the call
0540 7AE4 D4 0D                 pei   TheInput
0541 7AE6 22 F1 7D 02           jsl   ToInstallNDA
0542 7AEA
0543 7AEA AA                    tax                            ; save error code in x
0544 7AEB
0545 7AEB A0 04 00              ldy   #4
0546 7AEE 82 D6 FF              brl   ShutUsDown
0547 7AF1
0548 7AF1 22 5E DA FE  ToInstallNDA jsl   $00FEDA5E
0549 7AF5 6B                    rtl   
0550 7AF6
0551 7AF6                       ENDP 
0552 7AF6
0553 7AF6              ****************************************************************
0554 7AF6              *
0555 7AF6              OpenNDAentry PROC 
0556 7AF6              *
0557 7AF6              *
0558 7AF6                       longa on                       ; mode
0559 7AF6                       longi on
0560 7AF6              *
0561 7AF6              ****************************************************************
0562 7AF6                       import OpenNDA 
0563 7AF6
0564 7AF6 20 AC 7D              jsr   StartUsUp
0565 7AF9
0566 7AF9 48                    pha                            ; make the call
0567 7AFA D4 0D                 pei   TheInput
0568 7AFC 22 0A 7E 02           jsl   ToOpenNDA
0569 7B00 AA                    tax   
0570 7B01 68                    pla   
0571 7B02 85 0F                 sta   TheInput+2
0572 7B04
0573 7B04 A0 02 00              ldy   #2
0574 7B07 82 BD FF              brl   ShutUsDown
0575 7B0A
0576 7B0A              ;;ToOpenNDA	jsl	$00FEDB1C
0577 7B0A              ;;	rtl
0578 7B0A
0579 7B0A 22 B1 80 02  ToOpenNDA jsl   OpenNDA
0580 7B0E 6B                    rtl   
0581 7B0F
0582 7B0F                       ENDP 
0583 7B0F
0584 7B0F
0585 7B0F              ****************************************************************
0586 7B0F              *
0587 7B0F              CloseNDA PROC 
0588 7B0F              *
0589 7B0F              *
0590 7B0F                       longa on                       ; mode
0591 7B0F                       longi on
0592 7B0F              *
0593 7B0F              ****************************************************************
0594 7B0F
0595 7B0F
0596 7B0F 20 AC 7D              jsr   StartUsUp
0597 7B12
0598 7B12 D4 0D                 pei   TheInput
0599 7B14 22 1F 7E 02           jsl   ToCloseNDA
0600 7B18 AA                    tax   
0601 7B19
0602 7B19 A0 02 00              ldy   #2
0603 7B1C 82 A8 FF              brl   ShutUsDown
0604 7B1F
0605 7B1F 22 B7 DB FE  ToCloseNDA jsl   $00FEDBB7
0606 7B23 6B                    rtl   
0607 7B24
0608 7B24                       ENDP 
0609 7B24
0610 7B24
0611 7B24              ****************************************************************
0612 7B24              *
0613 7B24              GetNumNDAs PROC 
0614 7B24              *
0615 7B24              *
0616 7B24                       longa on                       ; mode
0617 7B24                       longi on
0618 7B24              *
0619 7B24              ****************************************************************
0620 7B24
0621 7B24
0622 7B24 20 AC 7D              jsr   StartUsUp
0623 7B27
0624 7B27 48                    pha   
0625 7B28 22 36 7E 02           jsl   ToGetNumNDAs
0626 7B2C AA                    tax   
0627 7B2D 68                    pla   
0628 7B2E 85 0D                 sta   TheInput
0629 7B30
0630 7B30 A0 00 00              ldy   #0
0631 7B33 82 91 FF              brl   ShutUsDown
0632 7B36
0633 7B36 22 90 DF FE  ToGetNumNDAs jsl   $00FEDF90
0634 7B3A 6B                    rtl   
0635 7B3B
0636 7B3B                       ENDP 
0637 7B3B
0638 7B3B
0639 7B3B              ****************************************************************
0640 7B3B              *
0641 7B3B              AddToRunQ PROC 
0642 7B3B              *
0643 7B3B              *
0644 7B3B                       longa on                       ; mode
0645 7B3B                       longi on
0646 7B3B              *
0647 7B3B              ****************************************************************
0648 7B3B
0649 7B3B 20 AC 7D              jsr   StartUsUp
0650 7B3E
0651 7B3E D4 0F                 pei   TheInput+2               ; make the call
0652 7B40 D4 0D                 pei   TheInput
0653 7B42 22 4D 7E 02           jsl   ToAddToRunQ
0654 7B46
0655 7B46 AA                    tax                            ; save error code in x
0656 7B47
0657 7B47 A0 04 00              ldy   #4
0658 7B4A 82 7A FF              brl   ShutUsDown
0659 7B4D
0660 7B4D 22 BD E0 FE  ToAddToRunQ jsl   $00FEE0BD
0661 7B51 6B                    rtl   
0662 7B52
0663 7B52                       ENDP 
0664 7B52
0665 7B52
0666 7B52              ****************************************************************
0667 7B52              *
0668 7B52              RemoveFromRunQ PROC 
0669 7B52              *
0670 7B52              *
0671 7B52                       longa on                       ; mode
0672 7B52                       longi on
0673 7B52              *
0674 7B52              ****************************************************************
0675 7B52
0676 7B52 20 AC 7D              jsr   StartUsUp
0677 7B55
0678 7B55 D4 0F                 pei   TheInput+2               ; make the call
0679 7B57 D4 0D                 pei   TheInput
0680 7B59 22 64 7E 02           jsl   ToRemoveFromRunQ
0681 7B5D
0682 7B5D AA                    tax                            ; save error code in x
0683 7B5E
0684 7B5E A0 04 00              ldy   #4
0685 7B61 82 63 FF              brl   ShutUsDown
0686 7B64
0687 7B64 22 E4 E0 FE  ToRemoveFromRunQ jsl   $00FEE0E4
0688 7B68 6B                    rtl   
0689 7B69
0690 7B69                       ENDP 
0691 7B69
0692 7B69                       END   
